<?php

//+++++++++++++++++++++++++++++++++++++++++
// カスタムポスト

//木の素材
register_post_type(
	'wood', 
	array(
		'label' => '木の素材',
		'hierarchical' => false,
		'public' => true,
		'query_var' => false,
		'menu_icon' => get_bloginfo('template_url').'/images/wood_icon_s.jpg',
		'supports' => array(
			'title', 
			'editor', 
			'thumbnail',
			'custom-fields'
		)
	)
);

register_taxonomy(
	'woodcat', 
	'wood', 
	array(
		'label' => '木の素材のカテゴリー',
		'hierarchical' => true,
	)
);


//布の素材
register_post_type(
	'fabric', 
	array(
		'label' => '布の素材',
		'hierarchical' => false,
		'public' => true,
		'query_var' => false,
		'menu_icon' => get_bloginfo('template_url').'/images/fabric_icon_s.jpg',
		'supports' => array(
			'title', 
			'editor', 
			'thumbnail',
			'custom-fields'
		)
	)
);

register_taxonomy(
	'fabriccat', 
	'fabric', 
	array(
		'label' => '布の素材のカテゴリー',
		'hierarchical' => true,
	)
);


//アイコン画像
add_action('admin_head', 'admin_head_style');
function admin_head_style() {
	global $post_type;
	if($post_type == 'wood' || $post_type == 'fabric') {
	?>
<style type="text/css">
#icon-edit	{background: url('<?php echo get_bloginfo('template_url'); ?>/images/<?php echo $post_type; ?>_icon.jpg');
	background-repeat: no-repeat;}
</style>
	<?php
	}
}



//+++++++++++++++++++++++++++++++++++++++++
// アイキャッチ画像
add_theme_support('post-thumbnails');

// 基本サイズ
set_post_thumbnail_size(400, 300, true);

// Ｍサイズ
add_image_size('msize', 328, 246, true);

// Ｓサイズ
add_image_size('ssize', 164, 123, true);


//+++++++++++++++++++++++++++++++++++++++++
//カスタムメニュー

register_nav_menus(array(
	'navbar' => 'ナビゲーションバー',
	'sidebar' => 'サイドバー',
	'topcontent' => 'トップページのコンテンツ'
	));


//+++++++++++++++++++++++++++++++++++++++++
//クラス名を追加
add_filter('body_class','my_class');
function my_class($classes) {
	if(is_page('fabric') || get_post_type()=='fabric'){
		$classes[] = 'fabric';
	}
	return $classes;
}

?>
